Vue.component('ruido',{
    data: function () {
        return {
          evento_modo: -1,
          chequeo_temperatura: true,
          chequeo_humedad: true,
          chequeo_viento_velocidad: true,
          id: store.state.datos_ruido.id,
          id_ref: store.state.datos_ruido.id_ref,
          id_registro: store.state.datos_registro.id,
          nro_sonometro: store.state.datos_ruido.nro_sonometro,
          met_estado: store.state.datos_ruido.met_estado,
          met_temperatura: store.state.datos_ruido.met_temperatura,
          met_humedad: store.state.datos_ruido.met_humedad,
          met_viento_velocidad: store.state.datos_ruido.met_viento_velocidad,
          met_viento_dir: store.state.datos_ruido.met_viento_dir,
          fotos: store.state.datos_ruido.fotos,
          audios: store.state.datos_ruido.audios,
          tmp_fotos: store.state.datos_ruido.tmp_fotos,
          tmp_audios: store.state.datos_ruido.tmp_audios,
          audios: store.state.datos_ruido.audios,
          usuario: store.state.datos_login.usuario,
          activo: store.state.datos_ruido.activo,
          eventos: store.state.datos_ruido.eventos,
          laeq: store.state.datos_ruido.laeq,
          lamx: store.state.datos_ruido.lamx,
          lamin: store.state.datos_ruido.lamin,
          la10: store.state.datos_ruido.la10,
          la50: store.state.datos_ruido.la50,
          la90: store.state.datos_ruido.la90,
          data: JSON.parse(store.state.datos_ruido.eventos),
          fotos_a_ver: [],
          audios_a_escuchar: [],
          ver_datos: true,
          modal_evento_activo: false,
          modal_grabar_audio: false,
          mic_estado: false,
          isImageModalActive: false,
          isAudioModalActive: false
        }
    },
    template: /*html*/`
<div>
<div class="box is-mobile has-background-light p-1 m-1">

    <div class="level bg-success" style="width:100%">  
    <p class="level-left title is-4 text-white bg-success p-2 m-2" >Medición ruido en registro</p>
    <b-button @click="guardar()" class="level-rigth p-2 m-2 is-success" style="width:120px" type="is-success" rounded  icon-left="cloud-upload">
    Guardar
    </b-button>
    </div>

  <div class="columns is-gapless is-multiline is-mobile m-1 p-1">                  
     <b-field class="field column is-full-mobile p-1 m-1" label="Nro:" type="is-success" style="width:80px">
         <b-input placeholder="Medición:" @input.native="actualizo_nro_sonometro" v-model="nro_sonometro"></b-input>
     </b-field>
     <b-field class="field column is-full-mobile p-1 m-1" label="Fecha calibración" style="width:180px">
      <b-datetimepicker v-model="calibracion"
       placeholder="Seleccionar fecha..."
       icon="calendar-today"
       horizontal-time-picker
       trap-focus >
      </b-datetimepicker>
    </b-field> 
     <b-field class="field column is-full-mobile p-1 m-1" label="Fecha medición" style="width:140px">
                <b-datepicker v-model="fecha"
                  placeholder="Seleccionar fecha..."
                  icon="calendar-today"
                  trap-focus >
              </b-datepicker>
      </b-field> 
      <b-field class="field column is-full-mobile p-1 m-1" label="Hora inicio" style="width:120px">
              <b-timepicker v-model="horaini"
                  rounded
                  placeholder="Hora..."
                  icon="clock">
              </b-timepicker>
      </b-field> 
    <b-field class="field column is-full-mobile p-1 m-1" label="Hora fin" style="width:120px">
                  <b-timepicker v-model="horafin"
                      rounded
                      placeholder="Hora..."
                      icon="clock">
                  </b-timepicker>
    </b-field> 
  </div>



  <div class="columns is-gapless is-multiline is-mobile m-1 p-1">     
                    <div class="column is-full-mobile p-1 m-1">
                          <b-field label="Cielo">
                          <b-select   @change.native="actualizo_met_estado($event)" v-model="met_estado" placeholder="Seleccionar clima">
                          <option value = "Despejado">Despejado</option>
                          <option value = "Parcialmente nublado">Parcialmente nublado</option>
                          <option value = "Parcialmente soleado">Parcialmente soleado</option>
                          <option value = "Cubierto">Cubierto</option>
                          </b-select>
                          </b-field>
                      </div> 
    <b-field class="field column is-full-mobile p-1 m-1" label="Temp:" type="is-success" style="width:80px">
     <b-input placeholder="Temperatura:"  @input.native="actualizo_met_temperatura" v-model="met_temperatura"></b-input>
    </b-field>
 
    <b-field class="field column is-full-mobile p-1 m-1" label="Hum:" type="is-success" style="width:80px">
     <b-input placeholder="Humedad:" @input.native="actualizo_met_humedad"  v-model="met_humedad"></b-input>
    </b-field>
     
    <b-field class="field column is-full-mobile p-1 m-1" label="Viento:" type="is-success" style="width:80px">
     <b-input placeholder="Viento:" @input.native="actualizo_met_viento_velocidad" v-model="met_viento_velocidad"></b-input>
    </b-field>

    <div class="column is-full-mobile p-1 m-1">
            <b-field label="Desde:">
            <b-select   @change.native="actualizo_met_viento_dir($event)" v-model="met_viento_dir" placeholder="Dirección viento">
            <option value = "N">N</option>
            <option value = "S">S</option>
            <option value = "E">E</option>
            <option value = "O">O</option>
            <option value = "NE">NE</option>
            <option value = "NO">NO</option>
            <option value = "SE">SE</option>
            <option value = "SO">SO</option>
            </b-select>
            </b-field>
    </div>
  </div>

  <b-field label="Observaciones">
              <b-input @input.native="actualizo_observaciones" v-model="observaciones" maxlength="500" type="textarea"></b-input>
  </b-field>

  <div class="level bg-secondary" style="width:100%">  
    <b-button class="ml-2 bg-secondary bordered border-secondary text-white" size="is-large" style="width:40px" @click="ver_datos = !ver_datos" :icon-right="ver_datos ? 'upload' : 'download'" >
    </b-button>
    <p class="level-left title is-4 text-white bg-secondary p-2 m-2">Eventos acústicos</p>
    <b-button @click="agregar_evento()" class="level-right p-2 m-2" type="is-light" rounded  icon-right="plus-circle">
    <strong> Agregar evento  </strong> 
    </b-button>
  </div>

  <div class="columns is-gapless m-1 p-1" v-for="(value, key) in data" v-if="ver_datos">
    <div class="column">
      <div class="columns border border-dark rounded is-gapless m-1 p-1">
          <div class="column bg-white rounded m-2 p-2">Tipo: {{value.tipo}}</div>
          <div class="column bg-white rounded m-2 p-2">Hora inicial: {{value.hora_ini.split(' ')[1]}}</div>
          <div class="column bg-white rounded m-2 p-2">Hora final: {{value.hora_fin.split(' ')[1]}}</div>
          <div class="column bg-white rounded m-2 p-2">Descripción: {{value.descripcion}}</div>
          <b-button class="column m-1 p-1 is-mobile" style="width:40px" @click.native="modifico_evento(key)" type="is-success" size="is-medium" icon-right="pen-plus"></b-button>
          <b-button class="column m-1 p-1 is-mobile" style="width:40px" @click.native="elimino_evento(key)" type="is-danger"  size="is-medium" icon-right="trash-can"></b-button>
      </div>
    </div>
  </div>


  <div class="columns is-gapless is-multiline is-mobile m-1 p-1">     

    <b-field class="field column is-full-mobile p-1 m-1" label="LAeq:" type="is-success" style="width:80px">
     <b-input placeholder="LAeq:"  @input.native="actualizo_laeq"  v-model="laeq"></b-input>
    </b-field>
 
    <b-field class="field column is-full-mobile p-1 m-1" label="LAmx:" type="is-success" style="width:80px">
     <b-input placeholder="LAmx:"   @input.native="actualizo_lamx" v-model="lamx"></b-input>
    </b-field>

    <b-field class="field column is-full-mobile p-1 m-1" label="LAmin:" type="is-success" style="width:80px">
    <b-input placeholder="LAmin:"  @input.native="actualizo_lamin"  v-model="lamin"></b-input>
   </b-field>
     
    <b-field class="field column is-full-mobile p-1 m-1" label="LA10:" type="is-success" style="width:80px">
     <b-input placeholder="LA10:"  @input.native="actualizo_la10" v-model="la10"></b-input>
    </b-field>

    <b-field class="field column is-full-mobile p-1 m-1" label="LA50:" type="is-success" style="width:80px">
    <b-input placeholder="LA50:"   @input.native="actualizo_la50" v-model="la50"></b-input>
   </b-field>

   <b-field class="field column is-full-mobile p-1 m-1" label="LA90:" type="is-success" style="width:80px">
   <b-input placeholder="LA90:"  @input.native="actualizo_la90" v-model="la90"></b-input>
   </b-field>

  </div>


  <b-modal :active.sync="isImageModalActive">
  <div id="carouselExampleControls" class="carousel slide">
      <div class="carousel-inner">
              <div class="carousel-item" v-for="(value,idx) in fotos_a_ver" :class="{active: idx==0 }">
              <p class="image is-5by3">
              <img class="has-ratio img-fluid" :src="value" alt="">
              </p>
              </div>
      </div>
      <ol class="carousel-indicators">
      <li data-target="#carouselExampleControls" data-slide-to="idx" class="active" v-for="(value,idx) in fotos_a_ver"></li>
      </ol>
      <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="sr-only">Previous</span>
    </a>
    <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="sr-only">Next</span>
    </a>
      </div>  
</b-modal>


<b-modal :active.sync="isAudioModalActive">
<div id="carouselExampleControls" class="carousel slide">
    <div class="carousel-inner ">
            <div class="carousel-item m-1 p-1 bg-dark" v-for="(value,idx) in audios_a_escuchar" :class="{active: idx==0 }">
            <div class="bg-dark m-2 p-2">
            <audio controls style="margin: 0 auto; display: block;"> <source :src="value"> </audio>
            </div>
            </div>
    </div>
    <ol class="carousel-indicators">
    <li data-target="#carouselExampleControls" data-slide-to="idx" class="active" v-for="(value,idx) in audios_a_escuchar"></li>
    </ol>
    <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
    <span class="sr-only">Previous</span>
  </a>
  <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
    <span class="carousel-control-next-icon" aria-hidden="true"></span>
    <span class="sr-only">Next</span>
  </a>
    </div>  
</b-modal>








    <footer >
          <form enctype="multipart/form-data">
          <input accept="image/*" @change="guardo_fotografia" capture="camera" id="foto_ruido" name="foto_ruido" ref="foto_ruido" style="display:none" type="file"> 
          </form>                   
    <div class="columns is-gapless is-multiline is-mobile m-1 p-1">
      <div class="column is-full-mobile  m-1 p-1">
        <b-button  @click="$refs.foto_ruido.click()" type="is-success" rounded  expanded  icon-left="camera-plus">
        Tomar Foto
        </b-button>






      </div>
      <div class="column is-full-mobile  m-1 p-1">
          <b-button  @click="ver_fotos()" type="is-success" rounded  expanded  icon-left="camera-image">
          Ver Fotos
          </b-button>
      </div>

      <div class="column is-full-mobile  m-1 p-1">

             
            <b-button  @click="modal_grabar_audio = true" type="is-success" rounded  expanded  icon-left="camera-plus">
            Grabar audio
            </b-button>

      </div>
      <div class="column is-full-mobile  m-1 p-1">
      <b-button  @click="escuchar_audios()" type="is-success" rounded  expanded  icon-left="camera-image">
      Escuchar audios
      </b-button>
      </div>

    <div class="column is-full-mobile  m-1 p-1">
    <b-button  @click="volver()" type="is-success" rounded  expanded  icon-left="arrow-left-circle">
    Volver
    </b-button>
    </div>

    </div>
    </footer>

  </div> 





  <b-modal :active.sync="modal_evento_activo"
  has-modal-card
  trap-focus
  :destroy-on-hide="false"
  aria-role="dialog"
  aria-modal>
  <form action="">
  <div class="modal-card" style="width: auto">
      <header class="modal-card-head">
          <p class="modal-card-title">Datos de evento</p>
      </header>
      <section class="modal-card-body">

      <div class="column is-full-mobile p-1 m-1">
      <b-field label="Tipo">
      <b-select   @change.native="actualizo_evento_tipo($event)" v-model="evento_tipo" placeholder="Tipo de evento">
      <option value = "Externo-Vehiculos">Externo-Vehiculos</option>
      <option value = "Externo-Animales">Externo-Animales</option>
      <option value = "Externo-Personas">Externo-Personas</option>
      <option value = "Externo-Otros">Externo-Otros</option>
      <option value = "Obra-Vehiculos">Obra-Vehiculos</option>
      <option value = "Obra-Maquinaria">Obra-Maquinaria</option>
      <option value = "Obra-Herramientas-Manuales">Obra-Herramientas-Manuales</option>
      <option value = "Obra-Actividades-Construccion">Obra-Actividades-Construccion</option>
      <option value = "Obra-Mantenimiento-Maquinaria">Obra-Mantenimiento-Maquinaria</option>
      <option value = "Obra-Otros">Obra-Otros</option>
      </b-select>
      </b-field>
  </div> 
  <b-field class="field column is-full-mobile p-1 m-1" label="Hora inicio" style="width:120px">
  <b-timepicker v-model="evento_horaini"
      rounded
      :enable-seconds=true
      placeholder="Hora..."
      icon="clock">
  </b-timepicker>
  </b-field> 
  <b-field class="field column is-full-mobile p-1 m-1" label="Hora fin" style="width:120px">
  <b-timepicker v-model="evento_horafin"
      rounded
      :enable-seconds=true
      placeholder="Hora..."
      icon="clock">
  </b-timepicker>
  </b-field> 

  <b-field label="Descripcion">
  <b-input @input.native="actualizo_evento_descripcion" v-model="evento_descripcion" maxlength="500" type="textarea"></b-input>
  </b-field>

      </section>
      <footer class="modal-card-foot">
          <button class="button" type="button" @click="modal_evento_activo=false">Cerrar</button>
          <b-button  @click="guardo_evento()" type="is-danger" icon-left="cloud-upload">
            Guardar
          </b-button>
      </footer>
  </div>
</form>
</b-modal>





<b-modal :active.sync="modal_grabar_audio"
has-modal-card
trap-focus
:destroy-on-hide="false"
aria-role="dialog"
aria-modal>
<form action="">
<div class="modal-card" style="width: auto">
    <header class="modal-card-head">
        <p class="modal-card-title">Grabar audio</p>
    </header>
    <section class="modal-card-body">
    <p class="subtitle is-5" style="color:blue" v-if="mic_estado">Grabando audio...</p>
    <b-progress type="is-primary" v-if="mic_estado" ></b-progress>
    </section>
    <footer class="modal-card-foot">
        <b-button  @click="iniciar_grabacion_audio()"   :type="mic_estado ? 'is-grey' : 'is-danger'" icon-left="microphone-plus">
        Iniciar grabación
        </b-button>
        <b-button  @click="finalizar_grabacion_audio()" :type="mic_estado ? 'is-danger' : 'is-grey'" icon-left="microphone-outline">
        Finalizar grabación
      </b-button>
    </footer>
</div>
</form>
</b-modal>




  </div>
 	
    `,
    computed:{
      fecha:{
        get:  function () {
        return new Date(store.state.datos_ruido.fecha);
         },
        set:  function (valor) {
          store.state.control_cambios = true;
          store.state.datos_ruido.fecha =  app.obtengo_fecha(valor);
          this.guardar();
          },
        },
        calibracion:{
          get:  function () {
          return new Date(store.state.datos_ruido.calibracion);
           },
          set:  function (valor) {
            store.state.control_cambios = true;
            store.state.datos_ruido.calibracion =  app.obtengo_fecha(valor);
            this.guardar();
            },
          },
        horaini:{
          get:  function () {
          return new Date(store.state.datos_ruido.hora_ini);
           },
          set:  function (valor) {
            store.state.control_cambios = true;
            store.state.datos_ruido.hora_ini = app.obtengo_fecha(valor);
            this.guardar();
            },
        },
        horafin:{
          get:  function () {
          return new Date(store.state.datos_ruido.hora_fin);
           },
          set:  function (valor) {
            store.state.control_cambios = true;
            store.state.datos_ruido.hora_fin = app.obtengo_fecha(valor);
            this.guardar();
            },
          },
          evento_horaini:{
            get:  function () {
            return new Date(store.state.datos_ruido.evento_hora_ini);
             },
            set:  function (valor) {
              store.state.control_cambios = true;
              store.state.datos_ruido.evento_hora_ini =  app.obtengo_fecha(valor);
              this.guardar();
              },
          },
          evento_horafin:{
            get:  function () {
            return new Date(store.state.datos_ruido.evento_hora_fin);
             },
            set:  function (valor) {
              store.state.control_cambios = true;
              store.state.datos_ruido.evento_hora_fin = app.obtengo_fecha(valor);
              this.guardar();
              },
            },
          evento_descripcion:{
              get:  function () {
              return store.state.datos_ruido.evento_descripcion;
               },
               set:  function (valor) {
                store.state.control_cambios = true;
                store.state.datos_ruido.evento_descripcion = valor;
                this.guardar();
              }
              },
          evento_tipo:{
              get:  function () {
              return store.state.datos_ruido.evento_tipo;
               },
              set:  function (valor) {
                store.state.control_cambios = true;
                store.state.datos_ruido.evento_tipo = valor;
                this.guardar();
              }
            },
            observaciones:{
              get:  function () {
              return store.state.datos_ruido.observaciones;
               },
              set:  function (valor) {
                store.state.control_cambios = true;
                store.state.datos_ruido.observaciones = valor;
                this.guardar();
              }
            } 
        },
    methods:{
      actualizo_nro_sonometro(e){
        store.state.datos_ruido.nro_sonometro = e.target.value;
        store.state.control_cambios = true;
        this.guardar();
      },
      actualizo_met_estado(e){
        store.state.datos_ruido.met_estado = e.target.value;
        store.state.control_cambios = true;
        this.guardar();
      },
      actualizo_met_temperatura(e){
        store.state.control_cambios = true;
        var temp = e.target.value;
        if(isNaN(temp) && temp != '-'){
          this.$buefy.toast.open('El valor de temperatura ingresado no es correcto');
          this.chequeo_temperatura = false;
        }
        else
        {
          if (temp > 60 || temp < -20)
           {
            this.$buefy.toast.open('El valor de temperatura ingresado no es correcto');
            this.chequeo_temperatura = false;
           }
           else
           {
            store.state.datos_ruido.met_temperatura = temp;
            this.chequeo_temperatura = true;
            this.guardar();
           }
        }  
      },
      actualizo_met_humedad(e){
        store.state.control_cambios = true;
        var hum = e.target.value;
        if(isNaN(hum)){
          this.$buefy.toast.open('El valor de humedad ingresado no es correcto');
          this.chequeo_humedad = false;
        }
        else
        {
          if (hum > 100 || hum < 0)
           {
            this.$buefy.toast.open('El valor de Humedad ingresado no es correcto');
            this.chequeo_humedad = false;
           }
           else
           {
            store.state.datos_ruido.met_humedad = hum;
            this.guardar();
            this.chequeo_humedad = true;
           }
        }  
      },
      actualizo_met_viento_dir(e){
        store.state.control_cambios = true;
        store.state.datos_ruido.met_viento_dir = e.target.value;
        this.guardar();
      },
      actualizo_met_viento_velocidad(e){
        store.state.control_cambios = true;
        var vel = e.target.value;
        if(isNaN(vel)){
          this.$buefy.toast.open('El valor de velocidad de viento ingresado no es correcto');
          this.chequeo_viento_velocidad = false;
        }
        else
        {
          if (vel > 5 || vel < 0)
           {
            this.$buefy.toast.open('El valor de velocidad de viento ingresado no es correcto');
            this.chequeo_viento_velocidad = false;
           }
           else
           {
            store.state.datos_ruido.met_viento_velocidad = vel;
            this.guardar();
            this.chequeo_viento_velocidad = true;
           }
        }  
      },
      actualizo_laeq(e){
        store.state.control_cambios = true;
        var val = e.target.value;
        if(isNaN(val)){
          this.$buefy.toast.open('El valor de laeq ingresado no es correcto');
        }
        else
        {
          if (val > 200 || val < 0)
           {
            this.$buefy.toast.open('El valor de laeq ingresado no es correcto');
           }
           else
           {
            store.state.datos_ruido.laeq = val;
            this.guardar();
           }
        }  
      },
      actualizo_lamx(e){
        store.state.control_cambios = true;
        var val = e.target.value;
        if(isNaN(val)){
          this.$buefy.toast.open('El valor de lamx ingresado no es correcto');
        }
        else
        {
          if (val > 200 || val < 0)
           {
            this.$buefy.toast.open('El valor de lamx ingresado no es correcto');
           }
           else
           {
            store.state.datos_ruido.lamx = val;
            this.guardar();
           }
        }  
      },
      actualizo_lamin(e){
        store.state.control_cambios = true;
        var val = e.target.value;
        if(isNaN(val)){
          this.$buefy.toast.open('El valor de lamin ingresado no es correcto');
        }
        else
        {
          if (val > 200 || val < 0)
           {
            this.$buefy.toast.open('El valor de lamin ingresado no es correcto');
           }
           else
           {
            store.state.datos_ruido.lamin = val;
            this.guardar();
           }
        }  
      }, 
      actualizo_la10(e){
        store.state.control_cambios = true;
        var val = e.target.value;
        if(isNaN(val)){
          this.$buefy.toast.open('El valor de la10 ingresado no es correcto');
        }
        else
        {
          if (val > 200 || val < 0)
           {
            this.$buefy.toast.open('El valor de la10 ingresado no es correcto');
           }
           else
           {
            store.state.datos_ruido.la10 = val;
            this.guardar();
           }
        }  
      },
      actualizo_la50(e){
        store.state.control_cambios = true;
        var val = e.target.value;
        if(isNaN(val)){
          this.$buefy.toast.open('El valor de la50 ingresado no es correcto');
        }
        else
        {
          if (val > 200 || val < 0)
           {
            this.$buefy.toast.open('El valor de la50 ingresado no es correcto');
           }
           else
           {
            store.state.datos_ruido.la50 = val;
            this.guardar();
           }
        }  
      },      
      actualizo_la90(e){
        store.state.control_cambios = true;
        var val = e.target.value;
        if(isNaN(val)){
          this.$buefy.toast.open('El valor de la90 ingresado no es correcto');
        }
        else
        {
          if (val > 200 || val < 0)
           {
            this.$buefy.toast.open('El valor de la90 ingresado no es correcto');
           }
           else
           {
            store.state.datos_ruido.la90 = val;
            this.guardar();
           }
        }  
      }, 
      actualizo_observaciones(e){
        store.state.control_cambios = true;
        store.state.datos_ruido.observaciones = e.target.value;
        this.guardar();
      },
      actualizo_evento_tipo(e){
        store.state.control_cambios = true;
        store.state.datos_ruido.evento_tipo = e.target.value;
        this.guardar();
      },
      actualizo_evento_descripcion(e){
        store.state.control_cambios = true;
        store.state.datos_ruido.evento_descripcion = e.target.value;
        this.guardar();
      },
      volver(){
        if (store.state.control_cambios === true){
              this.$buefy.dialog.confirm({
                title: 'Volver a mapa',
                message: 'Los cambios no guardados se perderán',
                confirmText: 'Confirma salir?',
                type: 'is-danger',
                hasIcon: true,
                onConfirm: () => store.state.layout_visible = 'layout_relevamientos'  
                })   
        }
        else
        {
          store.state.control_cambios = false;
          store.state.layout_visible = 'layout_relevamientos'
        }
      },
      modifico_evento(e){
        this.evento_modo=e;
        store.state.datos_ruido.evento_tipo =  this.data[e].tipo;
        store.state.datos_ruido.evento_hora_ini =  this.data[e].hora_ini;
        store.state.datos_ruido.evento_hora_fin =  this.data[e].hora_fin;
        store.state.datos_ruido.evento_descripcion =  this.data[e].descripcion;
        this.modal_evento_activo= true;
      },
      elimino_evento(e){
          this.data.splice(e,1);
          store.state.datos_ruido.eventos = JSON.stringify(this.data);
      },
      agregar_evento(){
        this.evento_modo=-1; 
        store.state.datos_ruido.evento_tipo = 'Externo-Vehiculos';
        store.state.datos_ruido.evento_hora_ini = app.obtengo_fecha(new Date());
        store.state.datos_ruido.evento_hora_fin = app.obtengo_fecha(new Date());
        store.state.datos_ruido.evento_descripcion = ''
        this.modal_evento_activo = true;
      },  
      guardo_evento(){
        if(this.evento_modo == -1)
        {
        var nuevo_registro = '{"tipo":"' + store.state.datos_ruido.evento_tipo + '","hora_ini":"' + store.state.datos_ruido.evento_hora_ini + '","hora_fin":"'+ store.state.datos_ruido.evento_hora_fin + '","descripcion":"'+ store.state.datos_ruido.evento_descripcion + '"}';
        var evento = JSON.parse(nuevo_registro);
        this.data.push(evento);
        store.state.datos_ruido.eventos = JSON.stringify(this.data);
        this.modal_evento_activo=false;
        }
        else
        {
          var nuevo_registro = '{"tipo":"' + store.state.datos_ruido.evento_tipo + '","hora_ini":"' + store.state.datos_ruido.evento_hora_ini + '","hora_fin":"'+ store.state.datos_ruido.evento_hora_fin + '","descripcion":"'+ store.state.datos_ruido.evento_descripcion + '"}';
          var evento = JSON.parse(nuevo_registro);
          this.data.splice(this.evento_modo,1,evento);
          store.state.datos_ruido.eventos = JSON.stringify(this.data);
          this.modal_evento_activo=false;
        }
        this.guardar();
      },
      async ver_fotos(){
        var resultado = [];
        if (store.state.datos_ruido.fotos == ''){
          this.$buefy.toast.open('No existe fotografia');
        }else
        {
          app.chequeo_conexion();
          if (store.state.hayconexion == true){
          //  console.log("entro en hay conexion");
            var resultado = [];
            var lista_fotos = store.state.datos_ruido.fotos.split(",");
            for(i=0;i<lista_fotos.length;i++)
            { 
              var ruta_a_foto = lista_fotos[i];
              await fetch(ruta_a_foto).then(res => {
                if(res.status == 200)
                  {
                    resultado.push(ruta_a_foto);
                  } 
              });
              if (i == (lista_fotos.length - 1))
              {
                if (resultado.length == 0){this.$buefy.toast.open('No existe fotografia guardada')};
              }
            }
            this.fotos_a_ver = resultado;
            this.isImageModalActive = true;
        }
        else
        {
          this.$buefy.toast.open('No se pueden ver las fotografías sin conexión');
        } 
        }
      },
      async escuchar_audios(){
        if (store.state.datos_ruido.audios == ''){
          this.$buefy.toast.open('No existe audio grabado');
        }else
        { 
          app.chequeo_conexion();
          if (store.state.hayconexion == true){
            console.log("entro en hay conexion");
            var resultado = [];
            var lista_audios = store.state.datos_ruido.audios.split(",");
            for(i=0;i<lista_audios.length;i++)
            { 
              var ruta_a_audio = lista_audios[i];
              await fetch(ruta_a_audio).then(res => {
                if(res.status == 200)
                  {
                    resultado.push(ruta_a_audio);
                  } 
              });
              if (i == (lista_audios.length - 1))
              {
                if (resultado.length == 0){this.$buefy.toast.open('No existe audio guardado')};
              }
            }
            this.audios_a_escuchar = resultado;
            this.isAudioModalActive = true;
        }
        else
        {
          this.$buefy.toast.open('No se pueden escuchar audios sin conexión');
        } 

        }
      },
      guardo_fotografia(e){//_______________________________________________________________________________________________
        var d = new Date();
            var dirupload;
            var ano = d.getFullYear();
            var mes = d.getMonth() + 1;
            if (mes < 10){
              mes = "0" + mes;
            }
            var dia = d.getDate();
            if (dia < 10){
              dia = "0" + dia;
            }
            var horas = d.getHours();
            var minutos = d.getMinutes();
            var segundos = d.getSeconds();
            nom_archivo_foto = "RUIDO" + "-" + ano + mes + dia + "-" + horas + "-" + minutos + "-" + segundos;
            let last_dot = e.target.files[0].name.lastIndexOf('.')
            let ext = e.target.files[0].name.slice(last_dot + 1)
        nom_archivo_foto = nom_archivo_foto + "." + ext;
        var valfoto = e.target.files[0];      
        var canvasBlob = foto_a_800(valfoto);
        canvasBlob.then(function(blob) {
          store.state.datos_ruido.archivosfotos.push(blob);
          store.state.datos_ruido.tmp_fotos.push(URL.createObjectURL(blob));
         // console.log( "IMAGEN1: " +JSON.stringify(store.state.datos_ruido.archivosfotos));
        //  console.log(  "IMAGEN2: " + JSON.stringify(store.state.datos_ruido.tmp_fotos));
        });
        if (store.state.datos_ruido.fotos == ''){
          store.state.datos_ruido.fotos = "/ADAPTA/archivos/fotos/" + nom_archivo_foto;
        }else
        {
        store.state.datos_ruido.fotos = store.state.datos_ruido.fotos +  ",/ADAPTA/archivos/fotos/" +  nom_archivo_foto;  
        }    
     // console.log(  "IMAGEN3: " + store.state.datos_ruido.fotos);
      },
      iniciar_grabacion_audio(){
        this.mic_estado = true;
        var media = {
          tag: 'audio',
          type: 'audio/ogg',
          ext: '.ogg',
          gUM: {audio: true}
        }
        var chunks = [];
        navigator.mediaDevices.getUserMedia(media.gUM).then(_stream => {
          stream = _stream;
          recorder = new MediaRecorder(stream);
          recorder.ondataavailable = e => {
            chunks.push(e.data);
            if(recorder.state == 'inactive'){
              let blob = new Blob(chunks, {type: media.type });
              var d = new Date();
              var dirupload;
              var ano = d.getFullYear();
              var mes = d.getMonth() + 1;
              if (mes < 10){
                mes = "0" + mes;
              }
              var dia = d.getDate();
              if (dia < 10){
                dia = "0" + dia;
              }
              var horas = d.getHours();
              var minutos = d.getMinutes();
              var segundos = d.getSeconds();
              nom_archivo_audio = "RUIDO" + "-" + ano + mes + dia + "-" + horas + "-" + minutos + "-" + segundos + '.ogg';
              store.state.datos_ruido.archivosaudios.push(blob);
              store.state.datos_ruido.tmp_audios.push(URL.createObjectURL(blob));
              if (store.state.datos_ruido.audios == ''){
                store.state.datos_ruido.audios = "/ADAPTA/archivos/audios/" + nom_archivo_audio;
              }else
              {
              store.state.datos_ruido.audios = store.state.datos_ruido.audios +  ",/ADAPTA/archivos/fotos/" + nom_archivo_audio;  
              }

            } 
          };
          recorder.start();
        }).catch("no se puede grabar audio");
      },
      finalizar_grabacion_audio(){
        this.mic_estado = false;
        recorder.stop();
       // console.log(store.state.datos_ruido.audios);
        this.modal_grabar_audio = false;
      },
    guardar(){
      
      if (this.chequeo_humedad && this.chequeo_temperatura && this.chequeo_viento_velocidad)
      {

            //Genero sentencia sql completa/////////////////////////////////////////////////////////////////////////////////////////  
                var usuario = store.state.datos_login.usuario;
                var sql1 = "UPDATE ruido_inspecciones SET ID = " + store.state.datos_ruido.id + ",ID_REGISTRO = " + store.state.datos_ruido.id_registro + ", NRO_SONOMETRO = ";
                var sql2 = store.state.datos_ruido.nro_sonometro + ", CALIBRACION= '" + store.state.datos_ruido.calibracion + "', FECHA= '" + store.state.datos_ruido.fecha + "', HORA_INI = '";
                var sql3 = store.state.datos_ruido.hora_ini + "', HORA_FIN= '" + store.state.datos_ruido.hora_fin + "', MET_ESTADO = '";
                var sql4 = store.state.datos_ruido.met_estado + "', MET_TEMPERATURA= " + store.state.datos_ruido.met_temperatura + ", MET_HUMEDAD = ";
                var sql5 = store.state.datos_ruido.met_humedad + ", MET_VIENTO_VELOCIDAD= " + store.state.datos_ruido.met_viento_velocidad + ", MET_VIENTO_DIR = '";
                var sql6 = store.state.datos_ruido.met_viento_dir + "', FOTOS= '" + store.state.datos_ruido.fotos + "', AUDIOS = '";
                var sql7 = store.state.datos_ruido.audios + "', OBSERVACIONES= '" + store.state.datos_ruido.observaciones + "', USUARIO = '";
                var sql8 = usuario + "', ACTIVO = " + store.state.datos_ruido.activo + ", EVENTOS = '";               
                var sql9 = store.state.datos_ruido.eventos + "', LAEQ= " + store.state.datos_ruido.laeq + ", LAMX = ";   
                var sql10 = store.state.datos_ruido.lamx + ", LAMIN= " + store.state.datos_ruido.lamin + ", LA10 = ";                 
                var sql11 = store.state.datos_ruido.la10 + ", LA50= " + store.state.datos_ruido.la50 + ", LA90 = ";                 
                var sql12 = store.state.datos_ruido.la90 + " WHERE ID = " + store.state.datos_ruido.id;

                sql = sql1 + sql2 + sql3 + sql4 + sql5 + sql6 + sql7 + sql8 + sql9 + sql10 + sql11 + sql12;

                  //  console.log(sql);
                  app.chequeo_conexion();
                if (store.state.hayconexion == true) { // si hay conexion........................................................................
                  //consulto base de datos
                  var fd = new FormData();
                  fd.append("sql",sql);
                  fd.append("fotos",store.state.datos_ruido.fotos);
                  for(var i=0;i<store.state.datos_ruido.archivosfotos.length;i++){
                    fd.append("archivosfotos[]", store.state.datos_ruido.archivosfotos[i]);
                  }
                 // console.log(store.state.datos_ruido.archivosaudios.length);
                  fd.append("audios",store.state.datos_ruido.audios);
                  for(var i=0;i<store.state.datos_ruido.archivosaudios.length;i++){
                    fd.append("archivosaudios[]", store.state.datos_ruido.archivosaudios[i]);
                  }
                      var getUrl = window.location;
                      var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
                      var phpfile = baseUrl + '/php/ruido_inspecciones_actualizar.php';
                      var xhr = new XMLHttpRequest();	
                      xhr.open('POST',phpfile,true);
                      xhr.onload = function() {
                      var data = JSON.parse(this.response);
                        caches.open('ADAPTA_CACHE-V1').then(cache => {
                          cache.match('/sincronizacion/ruido_inspecciones.json').then(item => {
                          cache.put('/sincronizacion/ruido_inspecciones.json', new Response(JSON.stringify(data)));
                          for(i=0;i<data.length;i++)
                          { 
                              if (data[i].id === store.state.datos_ruido.id)
                              {
                                store.state.datos_ruido.id_ref = data[i].id_ref;
                                store.state.layout_visible = 'principal_ruido';
                              }
                           }

                          });
                        });
                      };
                      xhr.send(fd);
                    }//fin si hay conexion........................................................................
                    else		
                    {
                      caches.open('ADAPTA_CACHE-V1').then(cache => {
                      var lista_fotos = store.state.datos_ruido.fotos.split(",");
                          for (var i=0; i< lista_fotos.length;i++){
                              var nombre_cache = lista_fotos[i];
                              cache.put(nombre_cache, new Response(store.state.datos_ruido.archivosfotos[i]));
                          }
                      var lista_audios = store.state.datos_ruido.audios.split(",");
                                  for (var i=0; i< lista_audios.length;i++){
                                      var nombre_cache = lista_audios[i];
                                      cache.put(nombre_cache, new Response(store.state.datos_ruido.archivosaudios[i]));
                              }
                      })
                             
                      var media = store.state.datos_ruido.fotos + "," + store.state.datos_ruido.audios;
                      if (media.length > 3){
                          if (media.substring(0,1) == ",")
                          {
                            media = media.substring(1);
                          }
                          var largomenos1 = media.length - 1;
                          if (media.slice(-1) == ",")
                          {
                            media = media.substring(0,largomenos1);
                          }
                      } 

                     agrego_registros_a_sincronizar(sql,media);
        
        
        /////////////////////////////////////////////////////////////////////////////////////////////
        var registro_a_actualizar = {
          "id_ref": store.state.datos_ruido.id_ref,
          "id": store.state.datos_ruido.id,
          "id_registro": store.state.datos_ruido.id_registro,
          "nro_sonometro": store.state.datos_ruido.nro_sonometro,
          "calibracion": store.state.datos_ruido.calibracion,
          "fecha": store.state.datos_ruido.fecha,
          "hora_ini": store.state.datos_ruido.hora_ini,
          "hora_fin": store.state.datos_ruido.hora_fin,
          "met_estado": store.state.datos_ruido.met_estado,
          "met_temperatura": store.state.datos_ruido.met_temperatura,
          "met_humedad": store.state.datos_ruido.met_humedad,
          "met_viento_velocidad": store.state.datos_ruido.met_viento_velocidad,
          "met_viento_dir": store.state.datos_ruido.met_viento_dir,
          "fotos": store.state.datos_ruido.fotos,
          "audios": store.state.datos_ruido.audios,
          "observaciones": store.state.datos_ruido.observaciones,
          "usuario": store.state.datos_login.usuario,
          "activo": store.state.datos_ruido.activo,
          "eventos": store.state.datos_ruido.eventos,
          "laeq": store.state.datos_ruido.laeq,
          "lamx": store.state.datos_ruido.lamx,
          "lamin": store.state.datos_ruido.lamin,
          "la10": store.state.datos_ruido.la10,
          "la50": store.state.datos_ruido.la50,
          "la90": store.state.datos_ruido.la90
        };
        caches.open('ADAPTA_CACHE-V1').then(cache => {
          cache.match('/sincronizacion/ruido_inspecciones.json').then(item => { 
            item.json().then(buffer => {
                var data = [];
                for(i=0;i<buffer.length;i++){
                  if (buffer[i].id == store.state.datos_ruido.id)
                  {
                    data.push(registro_a_actualizar);
                  }else
                  {
                  data.push(buffer[i]);
                  }
                }
                cache.put('/sincronizacion/ruido_inspecciones.json', new Response(JSON.stringify(data)));
                store.state.layout_visible = 'principal_ruido';
              })
            }) 
            .catch(function() {
                 console.log("encontro el cache de inspecciones de ruido vacio");
                 cache.put('/sincronizacion/ruido_inspecciones.json', new Response(JSON.stringify(registro_a_actualizar)));
                 store.state.layout_visible = 'principal_ruido';
              })
            });  
            }
      }
      else
      {
        this.$buefy.toast.open('Hay datos incorrectos. Corregir')
      }
      store.state.control_cambios = false;
    }
  }    
 })