Vue.component('editar_registro',{
    data: function () {
        return {
          id_ref: store.state.datos_registro.id_ref,
          id: store.state.datos_registro.id,
          latitud: store.state.datos_registro.latitud,
          longitud: store.state.datos_registro.longitud,
          tipo: store.state.datos_registro.tipo,
          tipo_obra: store.state.datos_registro.tipo_obra,
          punto: store.state.datos_registro.punto,
          progresiva: store.state.datos_registro.progresiva,
          obrador: store.state.datos_registro.obrador,
          foto: store.state.datos_registro.foto,
          tmp_foto: store.state.datos_registro.tmp_foto,
          frecuencia: store.state.datos_registro.frecuencia,
          fecha_ini: store.state.datos_registro.fecha_ini,
          tramo: store.state.datos_registro.tramo,
          zona_urbana: store.state.datos_registro.zona_urbana,
          frente_obra: store.state.datos_registro.frente_obra,
          isImageModalActive: false,
          nueva_latitud: 0,
          nueva_longitud: 0,
          hay_movimiento: 0
        }
    },
    template: /*html*/`
    <div>
    <div class="box is-mobile has-background-light p-1 m-1">
 
                     <p class="title is-4 text-white bg-success p-2 m-2" style="width:100%">Modificar registro {{id_ref}}</p>
               
                     <div class="columns m-1">
                       <div class="column is-full-mobile p-1 m-1">
                         <p class="level-item subtitle is-6"><strong>Tipo:</strong> {{tipo}}</p>
                       </div>
                       <div class="column is-full-mobile p-1 m-1">
                         <p class="level-item subtitle is-6"><strong>Progresiva:</strong> {{progresiva}}</p>
                       </div>                      
                       <div class="column is-full-mobile p-1 m-1">
                       <p class="level-item subtitle is-6"><strong>Tramo:</strong> {{tramo}}</p>
                       </div>  
                     </div>
 
                     <div class="columns m-1">
                       <div class="field column is-full-mobile p-1 m-1">
                       <b-switch true-value="Si" false-value="No" v-model="zona_urbana" type="is-success">
                       {{zona_urbana == 'Si' ? $store.state.datos_registro.zona_urbana = "Si" : $store.state.datos_registro.zona_urbana = "No"}}
                        zona poblada 
                       </b-switch>
                       </div>
                       <div class="field column is-full-mobile p-1 m-1">
                       <b-switch true-value="Si" false-value="No" v-model="frente_obra" type="is-success">
                       {{frente_obra == 'Si' ? $store.state.datos_registro.frente_obra = "Si" : $store.state.datos_registro.frente_obra = "No"}}
                        frente de obra 
                       </b-switch>
                       </div>
 
                       <b-field class="field column is-full-mobile p-1 m-1" label="Fecha de inicio">
                       <b-datepicker v-model="fecha_inicial"
                           placeholder="Seleccionar fecha..."
                           icon="calendar-today"
                           trap-focus>
                       </b-datepicker>
                       </b-field>
 
                       <div class="column is-full-mobile p-1 m-1">
                           <b-field label="Frecuencia">
                           <b-select  @change.native="cambio_frecuencia($event)" v-model="frecuencia" placeholder="Seleccionar frecuencia">
                           <option value = "Semanal">Semanal</option>
                           <option value = "Mensual">Mensual</option>
                           <option value = "Trimestral">Trimestral</option>
                           <option value = "Semestral">Semestral</option>
                           <option value = "Otros">Otros</option>
                           </b-select>
                           </b-field>
                       </div>  
                       <div class="column is-full-mobile p-1 m-1">
                           <b-field label="Tipo de Obra">
                           <b-select  @change.native="cambio_tipo_obra($event)" v-model="tipo_obra" placeholder="Seleccionar tipo obra">
                           <option value = "Obrador">Obrador</option>
                           <option value = "Deposito">Deposito</option>
                           <option value = "Planta de soldadura">Planta de soldadura</option>
                           <option value = "Acopios">Acopios</option>
                           <option value = "Planta de trituracion">Planta de trituracion</option>
                           <option value = "Taller">Taller</option>
                           <option value = "Otros">Otros</option>
                           </b-select>
                           </b-field>
                       </div> 
                     </div> 
                     <b-field label="Punto:" type="is-success">
                        <b-input placeholder="Punto:"  @input.native="actualizo_punto" v-model="punto"></b-input>
                     </b-field>
                     <b-field label="Obrador:" type="is-success">
                         <b-input placeholder="Obrador:"  @input.native="actualizo_obrador" v-model="obrador"></b-input>
                     </b-field>


                <div class="columns is-gapless is-multiline is-mobile m-1 p-1 border border-success">
                     <b-field class="m-1 p-1" label="Latitud:" type="is-success">
                        <b-input placeholder="Latitud:" @input.native="actualizo_latitud" v-model="latitud"></b-input>
                     </b-field>
                     <b-field class="m-1 p-1" label="Longitud:" type="is-success">
                         <b-input placeholder="Longitud:" @input.native="actualizo_longitud" v-model="longitud"></b-input>
                     </b-field>
                     <div class="column  m-1 p-1" style="width:50%">
                     <b-button  @click="mover_registro()" type="is-gray" rounded  expanded  icon-left="map-marker-radius">
                     Ajustar
                     </b-button>
                     </div>
                     <div class="column  m-1 p-1" style="width:50%">
                     <b-button  @click="mover_registro2()" type="is-danger" rounded  expanded  icon-left="map-marker-radius-outline">
                     Mover
                     </b-button>
                     </div>
                </div>


 
         <footer >
                     <form enctype="multipart/form-data">
                     <input accept="image/*" @change="guardo_fotografia" capture="camera" id="foto_registro" name="foto_registro" ref="foto_registro" style="display:none" type="file"> 
                     </form>                   
                 <div class="columns is-gapless is-multiline is-mobile m-1 p-1">
                     <div class="column is-full-mobile  m-1 p-1">
                     <b-button  @click="$refs.foto_registro.click()" type="is-success" rounded  expanded  icon-left="camera-plus">
                     Tomar Foto
                     </b-button>
 
                     <b-modal :active.sync="isImageModalActive">
                       <p class="image is-5by3 is-fullwidth">
                       <img class="has-ratio" v-if="$store.state.datos_registro.foto !== ''" v-bind:src="$store.state.datos_registro.foto" alt="Foto de sitio">
                       </p>
                     </b-modal>
                     </div>
 
 
                     <div class="column is-full-mobile  m-1 p-1">
                     <b-button  @click="actualizar_registro()" type="is-success" rounded  expanded  icon-left="cloud-upload">
                     Guardar
                     </b-button>
                     </div>
 
                     <div class="column is-full-mobile  m-1 p-1">
                     <b-button  @click="volver()" type="is-success" rounded  expanded  icon-left="arrow-left-circle">
                     Volver
                     </b-button>
                     </div>
 
                 </div>
                 </footer>
           </div>
  
  </div>  		
    `,
    computed:{
        fecha_inicial:{
          get:  function () {
          return new Date(store.state.datos_registro.fecha_ini)
           },
          set:  function (valor) {
            store.state.datos_registro.fecha_ini = valor.toISOString().slice(0, 19).replace('T', ' ');
            },
          }
   },
    methods:{
      volver(){
        store.state.layout_visible = 'layout_relevamientos'; 
      },
      cambio_frecuencia(e){
        store.state.datos_registro.frecuencia = e.target.value;
      },
      cambio_tipo_obra(e){
        store.state.datos_registro.tipo_obra = e.target.value;
      },      
      cambio_frecuencia(e){
        store.state.datos_registro.frecuencia = e.target.value;
      },
      cambio_fecha(){
        alert( store.state.datos_registro.fecha_ini );
      },
      actualizo_punto(e){//_______________________________________________________________________________________________
        store.state.datos_registro.punto = e.target.value;
      },
      actualizo_obrador(e){//_______________________________________________________________________________________________
        store.state.datos_registro.obrador = e.target.value;
      },    
      actualizo_latitud(e){
        var lat = e.target.value;
        if(isNaN(lat)){
          this.$buefy.toast.open('El valor de latitud ingresado no es correcto');
        }
        else
        {
          if (lat < -32.5 && lat > -34.9)
           {
             this.nueva_latitud = lat;
           }
           else
           {
            this.$buefy.toast.open('El valor de latitud ingresado no es correcto');
           }
        }  
      }, 
      actualizo_longitud(e){
        var lon = e.target.value;
        if(isNaN(lon)){
          this.$buefy.toast.open('El valor de longitud ingresado no es correcto');
        }
        else
        {
          if (lon < -56 && lon > -56.7)
           {
             this.nueva_longitud = lon;
           }
           else
           {
            this.$buefy.toast.open('El valor de longitud ingresado no es correcto');
           }
        }  
      },   
      mover_registro(){
         if (this.nueva_latitud < 0 && this.nueva_longitud < 0)
        {      
          this.hay_movimiento = 1;
        }
      },   
      mover_registro2(){
        if (this.nueva_latitud < 0 && this.nueva_longitud < 0)
        {  if (this.hay_movimiento == 0){       
          store.state.datos_registro.punto = "M_" + store.state.datos_registro.punto;
          this.hay_movimiento = 1;
        }
        }
      }, 
      guardo_fotografia(e){//_______________________________________________________________________________________________
        var d = new Date();
            var dirupload;
            var ano = d.getFullYear();
            var mes = d.getMonth() + 1;
            if (mes < 10){
              mes = "0" + mes;
            }
            var dia = d.getDate();
            if (dia < 10){
              dia = "0" + dia;
            }
            var horas = d.getHours();
            var minutos = d.getMinutes();
            var segundos = d.getSeconds();
            nom_archivo_foto = "REGISTRO" + "-" + ano + mes + dia + "-" + horas + "-" + minutos + "-" + segundos;
            let last_dot = e.target.files[0].name.lastIndexOf('.')
            let ext = e.target.files[0].name.slice(last_dot + 1)
        nom_archivo_foto = nom_archivo_foto + "." + ext;
        var valfoto = e.target.files[0];      
        var canvasBlob = foto_a_800(valfoto);
        canvasBlob.then(function(blob) {
          store.state.datos_registro.archivofoto = blob;
          store.state.datos_registro.tmp_foto = URL.createObjectURL(blob);
        });
      store.state.datos_registro.foto = "/ADAPTA/archivos/fotos/" +  nom_archivo_foto;    
      },  


      
      actualizar_registro(){  //_____________________________________________________________________________________________
    //Genero sentencia sql completa/////////////////////////////////////////////////////////////////////////////////////////  
        var fecha = app.obtengo_fecha(new Date());
        var usuario = store.state.datos_login.usuario;
        var sql = "";
        if (this.hay_movimiento == 1){
        var ubicacion_registro = "GeomFromText('POINT(" + this.nueva_latitud + " " + this.nueva_longitud + ")',4326)";	
        } else {
          var ubicacion_registro = "GeomFromText('POINT(" + store.state.datos_registro.latitud + " " + store.state.datos_registro.longitud + ")',4326)";
        }


        var sql1 = "UPDATE registros SET ";
        var sql2 = "UBICACION = " + ubicacion_registro + ", TIPO = '" + store.state.datos_registro.tipo  + "',PUNTO = '" + store.state.datos_registro.punto + "',PROGRESIVA ="; 
        var sql3 = store.state.datos_registro.progresiva + ", OBRADOR = '" + store.state.datos_registro.obrador + "',FOTO = '";       
        var sql4 = store.state.datos_registro.foto + "', FECHA ='" + fecha + "', USUARIO = '" + usuario + "', FRECUENCIA = '" + store.state.datos_registro.frecuencia;        
        var sql4b = "', TRAMO = " + store.state.datos_registro.tramo + ", ZONA_URBANA = '" + store.state.datos_registro.zona_urbana + "', FRENTE_OBRA = '" + store.state.datos_registro.frente_obra + "', FECHA_INI = '" + store.state.datos_registro.fecha_ini;
        var sql5 = "', TIPO_OBRA = '" + store.state.datos_registro.tipo_obra + "' WHERE ID = " + store.state.datos_registro.id;

            sql = sql1 + sql2 + sql3 + sql4 + sql4b + sql5;
    
          // console.log(sql);
            app.chequeo_conexion();
        if (store.state.hayconexion == true) { // si hay conexion........................................................................
          //consulto base de datos
          var fd = new FormData();
          fd.append("sql",sql);
          fd.append("sql_standard",'');
          fd.append("foto",store.state.datos_registro.foto);
          fd.append("archivofoto",store.state.datos_registro.archivofoto);
							var getUrl = window.location;
							var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
							var phpfile = baseUrl + '/php/registros_agregar.php';
							var xhr = new XMLHttpRequest();	
							xhr.open('POST',phpfile,true);
							xhr.onload = function() {
              //  console.log(this.response);
              var data = JSON.parse(this.response);
								caches.open('ADAPTA_CACHE-V1').then(cache => {
                  cache.match('/sincronizacion/registros.json').then(item => {
                  cache.put('/sincronizacion/registros.json', new Response(JSON.stringify(data)));
                  store.state.layout_visible = 'layout_relevamientos';
                  });
								});
							};
							xhr.send(fd);
						}//fin si hay conexion........................................................................
						else		
						{
                  caches.open('ADAPTA_CACHE-V1').then(cache => {
                    if (store.state.datos_registro.foto != ''){
                    var nombre_cache =  store.state.datos_registro.foto;
                    return cache.put(nombre_cache, new Response(store.state.datos_registro.archivofoto));
                    }
                  })
                  var foto =  store.state.datos_registro.foto;
                  agrego_registros_a_sincronizar(sql,foto);


/////////////////////////////////////////////////////////////////////////////////////////////


var registro_nuevo = {
  "id_ref": store.state.datos_registro.id_ref,
  "id": store.state.datos_registro.id,
  "tipo": store.state.datos_registro.tipo,
  "punto": store.state.datos_registro.punto,
  "progresiva": store.state.datos_registro.progresiva,
  "obrador": store.state.datos_registro.obrador,
  "ubicacion": store.state.datos_registro.ubicacion,
  "cant_insp": store.state.datos_registro.cant_insp,
  "activo": store.state.datos_registro.activo,
  "foto": store.state.datos_registro.foto,
  "tramo": store.state.datos_registro.tramo,
  "zona_urbana": store.state.datos_registro.zona_urbana,
  "frente_obra": store.state.datos_registro.frente_obra,
  "fecha_ini": store.state.datos_registro.fecha_ini,
  "frecuencia": store.state.datos_registro.frecuencia,
  "tipo_obra": store.state.datos_registro.tipo_obra
};
caches.open('ADAPTA_CACHE-V1').then(cache => {
  cache.match('/sincronizacion/registros.json').then(item => { 
    item.json().then(buffer => {
        var data = [];
        for(i=0;i<buffer.length;i++){
          if (store.state.datos_registro.id !== buffer[i].id){
          data.push(buffer[i]);
          }
        }
        data.push(registro_nuevo);
        cache.put('/sincronizacion/registros.json', new Response(JSON.stringify(data)));
        store.state.layout_visible = 'layout_relevamientos'; 
      })
    }) 

    });  
    forzar_carga_registros == true;   
    }

    }
    }
            
 })