Vue.component('dl_relevamientos',{
  data: function () {
    return {
  empresa: "Adapta-UPM",
  logo: 'archivos/logos/icon-384x384.png',
  modal_elegir_reporte: false,
  modal_elegir_kml: false
    }
},	
template: /*html*/`
      <div>
        <div class="box is-mobile has-background-success p-2 m-2">
                <b-button  type="is-success" v-on:click="volver()"    icon-left="chevron-double-left"></b-button>
                <b-button  type='is-success' inverted   v-on:click="agrego_ruido()" rounded icon-left="volume-high" style="width:40px"></b-button>
                <b-button  class="mr-2" type='is-danger'  v-on:click="posicion_gps()" icon-left="map-marker" style="width:40px;float:right"></b-button>
                <b-button  class="mr-2" type='is-warning'  v-on:click="reportes()" icon-left="export" style="width:40px;float:right"></b-button>
                <b-button  class="mr-2" type='is-info'  v-on:click="reportes_kml()" rounded icon-left="earth" style="width:40px;float:right"></b-button>
              
        </div>
        <div id="map" style="z-index:0"></div>

        <b-modal :active.sync="modal_elegir_reporte"
        has-modal-card
        trap-focus
        :destroy-on-hide="false"
        aria-role="dialog"
        aria-modal>
        <form action="">
        <div class="modal-card" style="width: auto">
            <header class="modal-card-head">
                <p class="modal-card-title">Elegir reporte</p>
            </header>
            <section class="modal-card-body">
            <b-button  @click="reporte_ruido_tipo1"  type='is-success' icon-left="export">
            Reporte general Ruido
            </b-button>
            </section>
            <footer class="modal-card-foot">
                <b-button  @click="modal_elegir_reporte=false"" type='is-danger' icon-right="backburger" style="float:right">
                Volver
              </b-button>
            </footer>
        </div>
        </form>
        </b-modal>

        <b-modal :active.sync="modal_elegir_kml"
        has-modal-card
        trap-focus
        :destroy-on-hide="false"
        aria-role="dialog"
        aria-modal>
        <form action="">
        <div class="modal-card" style="width: auto">
            <header class="modal-card-head">
                <p class="modal-card-title">Elegir kml</p>
            </header>
            <section class="modal-card-body">
            <b-button  @click="generar_kml_ruido_tipo1"  type='is-success' icon-left="export">
            General kml Ruido
            </b-button>
            </section>
            <footer class="modal-card-foot">
                <b-button  @click="modal_elegir_kml=false"" type='is-danger' icon-right="backburger" style="float:right">
                Volver
              </b-button>
            </footer>
        </div>
        </form>
        </b-modal>


      </div>
`,
    methods:
    {
      generar_kml_ruido_tipo1: function(){
        app.genero_kml_ruido_tipo1();
       },   
      reporte_ruido_tipo1: function(){
        app.genero_reporte_ruido_tipo1(); 
       },   
       reportes_kml: function(){
        this.modal_elegir_kml = true; 
       }, 
      reportes: function(){
        this.modal_elegir_reporte = true; 
       },     
      posicion_gps: function(){
        map.setView([store.state.centro_gps.latitud,store.state.centro_gps.longitud], store.state.centro_gps.zoom, false); 
       },        
        volver: function(){
                        store.state.layout_visible = 'layout_menu_principal';  
        },
        agrego_ruido: function(){
          store.state.datos_registro.cant_insp = 0;
          app.obtengo_progresiva(map.getCenter().lat, map.getCenter().lng).then (response => {
          store.state.datos_registro.progresiva = response;
          if (store.state.datos_registro.progresiva <= 30000)
          {
            store.state.datos_registro.tramo = 1;
          }else if(store.state.datos_registro.progresiva <= 89000)
          {
            store.state.datos_registro.tramo = 2;
          }else if(store.state.datos_registro.progresiva <= 149000)
          {
            store.state.datos_registro.tramo = 3;
          }else if(store.state.datos_registro.progresiva <= 197000)
          {
            store.state.datos_registro.tramo = 4;
          }else 
          {
            store.state.datos_registro.tramo = 5;
          }

          var ubica = "POINT(" + map.getCenter().lat + " " + map.getCenter().lng + ")";
var nuevo_id = obtengo_nuevo_id();
          store.state.datos_registro.id = nuevo_id;
          store.state.datos_registro.ubicacion = ubica;
          store.state.datos_registro.tipo = "Ruido";
          store.state.datos_registro.foto = '';
          store.state.datos_registro.punto = '';
          store.state.datos_registro.obrador = '';
          store.state.datos_registro.fecha_ini = '2020-07-15';          
          store.state.datos_registro.tmp_foto = '';
          store.state.layout_visible = 'nuevo_registro';

          return(response);
         })
                                }                         
    },
    mounted: function () {
      app.obtengo_ubicacion();
var retoma_conexion = hayconexion;
 //CARGO MAPA LEAFLET DE PAGINA//////////////////////////////////////////////////////     
        map = new L.Map('map', {
          zoomControl: false
      });
        map.setView([store.state.centro_mapa.latitud,store.state.centro_mapa.longitud], store.state.centro_mapa.zoom, false);
        marca_centro = L.circleMarker(map.getCenter(),{
          radius: 8.0,
          color: 'red',
          weight: 3,
          opacity: 1.0,
          fill: false
        }).addTo(map);


        CapaOSM = L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token={accessToken}', {
          attribution: 'OpenStreetMap-Mapbox',
          maxZoom: 19,
          id: 'mapbox/light-v9',
          tileSize: 512,
          zoomOffset: -1,
          accessToken: 'pk.eyJ1IjoiZGxhcm5hdWRpZSIsImEiOiJjanRuOGxkMXAwZWtqNDVwNTg2cDVibXJvIn0.kyAGq_iDG6KP_0-7eB7n_g'
      }).addTo(map);



    /* CapaESRI = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', {
        attribution: 'Esri GeoEye',
        maxZoom: 19
      }).addTo(map);
*/

      var BING_KEY = 'AuhiCJHlGzhg93IqUH_oCpl_-ZUrIE6SPftlyGYUvr9Amx5nzA-WqGcPquyFZl4L'

  
      var CapaESRI = L.tileLayer.bing(BING_KEY).addTo(map)
      
        fetch("archivos/geo/Eje_Via_Progresivas1000.geojson")
        .then(function(response) {
        return response.json();
        })
        .then(function(data) {
          function estiloCircleMarker(feature, latlng) {
            label = String(feature.properties.PROGRESIVA)
            return L.circleMarker(latlng, {
              radius: 5.0,
              fillColor: 'blue',
              color: '#FFFFFF',
              weight: 2,
              opacity: 1.0,
              fillOpacity: 1.0
            }).bindTooltip(label, {permanent: true, opacity: 0.7}).openTooltip();
          }  
        Eje_Via_Progresivas1000= L.geoJSON(data, {pointToLayer: estiloCircleMarker}).addTo(map);
        });

/*
        fetch("archivos/geo/Ruido_provisorio.geojson")
        .then(function(response) {
        return response.json();
        })
        .then(function(data) {
          function estiloCircleMarker(feature, latlng) {
            label = String(feature.properties.ID);
            return L.circleMarker(latlng, {
              radius: 5.0,
              fillColor: 'blue',
              color: '#FFFFFF',
              weight: 2,
              opacity: 1.0,
              fillOpacity: 1.0
            }).bindTooltip(label, {permanent: true, opacity: 0.7}).openTooltip();
          }  
          Ruido_provisorio= L.geoJSON(data, {pointToLayer: estiloCircleMarker}).addTo(map);
        });

*/
        fetch("archivos/geo/Eje_Via_Progresivas20.geojson")
        .then(function(response) {
        return response.json();
        })
        .then(function(data) {
//CARGA DE FRENTES DE OBRA///////////////////////////////////////////////////////////////////////////
          var frentes_obra = [];
          frentes_obra.push([124000,125000]);
          frentes_obra.push([190000,191000]);
          var lista_frentes_obra = [];
          for (i=0;i<12200;i++)
          {
            var progresiva = data.features[i].properties.PROGRESIVA;
             for (j=0;j<frentes_obra.length;j++) 
             {
               if(progresiva >= frentes_obra[j][0] && progresiva <= frentes_obra[j][1])
                {
                  var elemento = [j,data.features[i].geometry.coordinates];
                  lista_frentes_obra.push(elemento);
                }
             }
          }
         //console.log(JSON.stringify(lista_frentes_obra)); 
          var coordenadas = [];
          var coordenadas_tramo = [];
          if (lista_frentes_obra.length > 0)
          {
          var tramo_anterior = lista_frentes_obra[0][0];
          }
          for (i=0;i<lista_frentes_obra.length;i++)
          {
                coordenadas_tramo.push(lista_frentes_obra[i][1]);
                if (lista_frentes_obra[i][0] != tramo_anterior || i == (lista_frentes_obra.length - 1))
                { coordenadas_tramo.pop();
                  coordenadas.push(coordenadas_tramo);
                  coordenadas_tramo = [];
                  coordenadas_tramo.push(lista_frentes_obra[i][1]);
                }
                tramo_anterior = lista_frentes_obra[i][0];    
          }
         //console.log(JSON.stringify(coordenadas)); 
          var geojsonFeature = {"type": "FeatureCollection","properties": {"nombre": "Frentes de obra"},"features":[]};
            for (i=0;i<coordenadas.length;i++)
                              { var lineas = { 
                                "type":"Feature",
                                "properties": {},
                                "geometry": {
                                                   "type": "LineString",
                                                   "coordinates": coordenadas[i]
                                              }
                                              };
                                 geojsonFeature.features.push(lineas);                       
                              };                                  
         // console.log(JSON.stringify(geojsonFeature));
          var myStyle = {
            "color": "#ff7800",
            "weight": 70,
            "opacity": 0.5
        };
        frentes_de_obra = L.geoJSON(geojsonFeature, {
          style: myStyle
        }).addTo(map);
           
        //Eje_Via_Progresivas20= L.geoJSON(data).addTo(map);
 //FIN DE FRENTES DE OBRA/////////////////////////////////////////////////////////////////////////////////////
        });

        fetch("archivos/geo/Eje_Via_Linea20.geojson")
        .then(function(response) {
        return response.json();
        })
        .then(function(data) {
        var myStyle = {
            "color": "magenta",
            "weight": 5,
            "opacity": 0.65
        };
        Eje_Via_Linea20 = L.geoJSON(data, {
        style: myStyle
        }).addTo(map);
        });



        fetch("archivos/geo/UY_Caminos_Faja1k.geojson")
        .then(function(response) {
        return response.json();
        })
        .then(function(data) {
        var myStyle = {
            "color": "#9a6024",
            "weight": 3,
            "opacity": 0.75
        };
        UY_Caminos_Faja1k = L.geoJSON(data, {
        style: myStyle
        }).addTo(map);
        });



        fetch("archivos/geo/UY_Hidro_Faja1k.geojson")
        .then(function(response) {
        return response.json();
        })
        .then(function(data) {
        var myStyle = {
            "color": "#3d67c2",
            "weight": 3,
            "opacity": 1
        };
        UY_Hidro_Faja1k = L.geoJSON(data, {
        style: myStyle
        }).addTo(map);
        });
/*
        CapaOSM = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
          maxZoom: 19,
          attribution: '&copy; <a href="https://openstreetmap.org/copyright">OpenStreetMap contributors</a>',
          useCache: true
        }).addTo(map);
*/
      map.on('dragend',function(){
        var centro = L.latLng(map.getCenter());
        store.state.centro_mapa.latitud = centro.lat;
        store.state.centro_mapa.longitud = centro.lng;
        store.state.centro_mapa.zoom = map.getZoom();
        marca_centro.setLatLng(centro);
        if(retoma_conexion !== hayconexion)
        {
          app.cargar_registros_a_mapa(map);
          retoma_conexion = hayconexion;
        }
        if(forzar_carga_registros == true)
        {
          app.cargar_registros_a_mapa(map);
          forzar_carga_registros = false;
        }
     })

      map.on('dragstart', function() {
      if (app.control_cambio_conexion == true)
      {
        if (hayconexion == true)
        {
            map.addLayer(CapaOSM);
            map.addLayer(CapaESRI);          
        }
        else
        {
          if (map.hasLayer(CapaOSM)){map.removeLayer(CapaOSM);} 
          if (map.hasLayer(CapaESRI)){map.removeLayer(CapaESRI);} 
        }
        app.control_cambio_conexion = hayconexion;
      };  
        
      });

      map.on('zoomend', function() {
        var zoomlevel = map.getZoom();
        if (zoomlevel  <14){
            if (map.hasLayer(Eje_Via_Progresivas1000)) {
                map.removeLayer(Eje_Via_Progresivas1000);
            } else {
                //console.log("no point layer active");
            }
        }
        if (zoomlevel >= 14){
            if (map.hasLayer(Eje_Via_Progresivas1000)){
               // console.log("layer already added");
            } else {
                map.addLayer(Eje_Via_Progresivas1000);
            }
        }
    //console.log("Current Zoom Level =" + zoomlevel)
      });

      var baseLayers = {
        "Foto": CapaESRI,
        "Calles": CapaOSM
      };
    
      var overlays = {
        
      };

      L.control.layers(baseLayers,overlays,{
        position: 'bottomleft',
        collapsed: true
      }).addTo(map);

      L.control.zoom({
        position: 'bottomright'
    }).addTo(map);

      app.cargar_registros_a_mapa(map);
    
    }


  })

    
 

 